package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.BooleanObject
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ApplicationSnapshotConfiguration(
    snapshotsEnabled: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration = {
    import ApplicationSnapshotConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration
      .builder()
      .snapshotsEnabled(snapshotsEnabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration
      .wrap(buildAwsValue())
}
object ApplicationSnapshotConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration =
      zio.aws.kinesisanalyticsv2.model
        .ApplicationSnapshotConfiguration(snapshotsEnabled)
    def snapshotsEnabled: BooleanObject
    def getSnapshotsEnabled: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(snapshotsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration.ReadOnly {
    override val snapshotsEnabled: BooleanObject =
      impl.snapshotsEnabled(): BooleanObject
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration
  ): zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration.ReadOnly =
    new Wrapper(impl)
}
