package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddApplicationInputRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    input: zio.aws.kinesisanalyticsv2.model.Input
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest = {
    import AddApplicationInputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .input(input.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationInputRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationInputRequest
      .wrap(buildAwsValue())
}
object AddApplicationInputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationInputRequest =
      zio.aws.kinesisanalyticsv2.model.AddApplicationInputRequest(
        applicationName,
        currentApplicationVersionId,
        input.asEditable
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def input: zio.aws.kinesisanalyticsv2.model.Input.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getInput
        : ZIO[Any, Nothing, zio.aws.kinesisanalyticsv2.model.Input.ReadOnly] =
      ZIO.succeed(input)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationInputRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val input: zio.aws.kinesisanalyticsv2.model.Input.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.Input.wrap(impl.input())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputRequest
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationInputRequest.ReadOnly =
    new Wrapper(impl)
}
