package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EnvironmentPropertyDescriptions(
    propertyGroupDescriptions: Option[
      Iterable[zio.aws.kinesisanalyticsv2.model.PropertyGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions = {
    import EnvironmentPropertyDescriptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions
      .builder()
      .optionallyWith(
        propertyGroupDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.propertyGroupDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions
      .wrap(buildAwsValue())
}
object EnvironmentPropertyDescriptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions =
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions(
        propertyGroupDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def propertyGroupDescriptions
        : Option[List[zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly]]
    def getPropertyGroupDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "propertyGroupDescriptions",
      propertyGroupDescriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions
  ) extends zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions.ReadOnly {
    override val propertyGroupDescriptions: Option[
      List[zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly]
    ] = scala
      .Option(impl.propertyGroupDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.PropertyGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions
  ): zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions.ReadOnly =
    new Wrapper(impl)
}
