package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  PropertyValue,
  PropertyKey,
  Id
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PropertyGroup(
    propertyGroupId: Id,
    propertyMap: Map[PropertyKey, PropertyValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup = {
    import PropertyGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup
      .builder()
      .propertyGroupId(Id.unwrap(propertyGroupId): java.lang.String)
      .propertyMap(
        propertyMap
          .map({ case (key, value) =>
            (PropertyKey.unwrap(key): java.lang.String) -> (PropertyValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.PropertyGroup.wrap(buildAwsValue())
}
object PropertyGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.PropertyGroup =
      zio.aws.kinesisanalyticsv2.model
        .PropertyGroup(propertyGroupId, propertyMap)
    def propertyGroupId: Id
    def propertyMap: Map[PropertyKey, PropertyValue]
    def getPropertyGroupId: ZIO[Any, Nothing, Id] = ZIO.succeed(propertyGroupId)
    def getPropertyMap: ZIO[Any, Nothing, Map[PropertyKey, PropertyValue]] =
      ZIO.succeed(propertyMap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup
  ) extends zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly {
    override val propertyGroupId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives.Id(impl.propertyGroupId())
    override val propertyMap: Map[PropertyKey, PropertyValue] = impl
      .propertyMap()
      .asScala
      .map({ case (key, value) =>
        zio.aws.kinesisanalyticsv2.model.primitives.PropertyKey(
          key
        ) -> zio.aws.kinesisanalyticsv2.model.primitives.PropertyValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.PropertyGroup
  ): zio.aws.kinesisanalyticsv2.model.PropertyGroup.ReadOnly = new Wrapper(impl)
}
