package zio.aws.kinesisanalyticsv2.model
import scala.jdk.CollectionConverters.*
sealed trait CodeContentType {
  def unwrap
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType
}
object CodeContentType {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType
  ): zio.aws.kinesisanalyticsv2.model.CodeContentType = value match {
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType.PLAINTEXT =>
      val r = PLAINTEXT
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType.ZIPFILE =>
      val r = ZIPFILE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalyticsv2.model.CodeContentType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object PLAINTEXT
      extends zio.aws.kinesisanalyticsv2.model.CodeContentType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType.PLAINTEXT
  }
  case object ZIPFILE extends zio.aws.kinesisanalyticsv2.model.CodeContentType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentType.ZIPFILE
  }
}
