package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ApplicationConfigurationDescription(
    sqlApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription
    ] = None,
    applicationCodeConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription
    ] = None,
    runConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.RunConfigurationDescription
    ] = None,
    flinkApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
    ] = None,
    environmentPropertyDescriptions: Option[
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions
    ] = None,
    applicationSnapshotConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription
    ] = None,
    vpcConfigurationDescriptions: Option[
      Iterable[zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription]
    ] = None,
    zeppelinApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription = {
    import ApplicationConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription
      .builder()
      .optionallyWith(
        sqlApplicationConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.sqlApplicationConfigurationDescription)
      .optionallyWith(
        applicationCodeConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.applicationCodeConfigurationDescription)
      .optionallyWith(
        runConfigurationDescription.map(value => value.buildAwsValue())
      )(_.runConfigurationDescription)
      .optionallyWith(
        flinkApplicationConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.flinkApplicationConfigurationDescription)
      .optionallyWith(
        environmentPropertyDescriptions.map(value => value.buildAwsValue())
      )(_.environmentPropertyDescriptions)
      .optionallyWith(
        applicationSnapshotConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.applicationSnapshotConfigurationDescription)
      .optionallyWith(
        vpcConfigurationDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcConfigurationDescriptions)
      .optionallyWith(
        zeppelinApplicationConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.zeppelinApplicationConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationDescription
      .wrap(buildAwsValue())
}
object ApplicationConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationDescription(
        sqlApplicationConfigurationDescription.map(value => value.asEditable),
        applicationCodeConfigurationDescription.map(value => value.asEditable),
        runConfigurationDescription.map(value => value.asEditable),
        flinkApplicationConfigurationDescription.map(value => value.asEditable),
        environmentPropertyDescriptions.map(value => value.asEditable),
        applicationSnapshotConfigurationDescription.map(value =>
          value.asEditable
        ),
        vpcConfigurationDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        zeppelinApplicationConfigurationDescription.map(value =>
          value.asEditable
        )
      )
    def sqlApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription.ReadOnly
    ]
    def applicationCodeConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription.ReadOnly
    ]
    def runConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.RunConfigurationDescription.ReadOnly
    ]
    def flinkApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription.ReadOnly
    ]
    def environmentPropertyDescriptions: Option[
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions.ReadOnly
    ]
    def applicationSnapshotConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription.ReadOnly
    ]
    def vpcConfigurationDescriptions: Option[List[
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly
    ]]
    def zeppelinApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription.ReadOnly
    ]
    def getSqlApplicationConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sqlApplicationConfigurationDescription",
      sqlApplicationConfigurationDescription
    )
    def getApplicationCodeConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationCodeConfigurationDescription",
      applicationCodeConfigurationDescription
    )
    def getRunConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.RunConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "runConfigurationDescription",
      runConfigurationDescription
    )
    def getFlinkApplicationConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "flinkApplicationConfigurationDescription",
      flinkApplicationConfigurationDescription
    )
    def getEnvironmentPropertyDescriptions: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "environmentPropertyDescriptions",
      environmentPropertyDescriptions
    )
    def getApplicationSnapshotConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationSnapshotConfigurationDescription",
      applicationSnapshotConfigurationDescription
    )
    def getVpcConfigurationDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "vpcConfigurationDescriptions",
      vpcConfigurationDescriptions
    )
    def getZeppelinApplicationConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "zeppelinApplicationConfigurationDescription",
      zeppelinApplicationConfigurationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationDescription.ReadOnly {
    override val sqlApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.sqlApplicationConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription
          .wrap(value)
      )
    override val applicationCodeConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.applicationCodeConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription
          .wrap(value)
      )
    override val runConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.RunConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.runConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.RunConfigurationDescription.wrap(value)
      )
    override val flinkApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.flinkApplicationConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
          .wrap(value)
      )
    override val environmentPropertyDescriptions: Option[
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions.ReadOnly
    ] = scala
      .Option(impl.environmentPropertyDescriptions())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions
          .wrap(value)
      )
    override val applicationSnapshotConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.applicationSnapshotConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription
          .wrap(value)
      )
    override val vpcConfigurationDescriptions: Option[List[
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly
    ]] = scala
      .Option(impl.vpcConfigurationDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription
            .wrap(item)
        }.toList
      )
    override val zeppelinApplicationConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.zeppelinApplicationConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
