package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.InAppStreamName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Input(
    namePrefix: InAppStreamName,
    inputProcessingConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration
    ] = None,
    kinesisStreamsInput: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsInput
    ] = None,
    kinesisFirehoseInput: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInput
    ] = None,
    inputParallelism: Option[
      zio.aws.kinesisanalyticsv2.model.InputParallelism
    ] = None,
    inputSchema: zio.aws.kinesisanalyticsv2.model.SourceSchema
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.Input = {
    import Input.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.Input
      .builder()
      .namePrefix(InAppStreamName.unwrap(namePrefix): java.lang.String)
      .optionallyWith(
        inputProcessingConfiguration.map(value => value.buildAwsValue())
      )(_.inputProcessingConfiguration)
      .optionallyWith(kinesisStreamsInput.map(value => value.buildAwsValue()))(
        _.kinesisStreamsInput
      )
      .optionallyWith(kinesisFirehoseInput.map(value => value.buildAwsValue()))(
        _.kinesisFirehoseInput
      )
      .optionallyWith(inputParallelism.map(value => value.buildAwsValue()))(
        _.inputParallelism
      )
      .inputSchema(inputSchema.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.Input.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.Input.wrap(buildAwsValue())
}
object Input {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.Input
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.Input =
      zio.aws.kinesisanalyticsv2.model.Input(
        namePrefix,
        inputProcessingConfiguration.map(value => value.asEditable),
        kinesisStreamsInput.map(value => value.asEditable),
        kinesisFirehoseInput.map(value => value.asEditable),
        inputParallelism.map(value => value.asEditable),
        inputSchema.asEditable
      )
    def namePrefix: InAppStreamName
    def inputProcessingConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly
    ]
    def kinesisStreamsInput
        : Option[zio.aws.kinesisanalyticsv2.model.KinesisStreamsInput.ReadOnly]
    def kinesisFirehoseInput
        : Option[zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInput.ReadOnly]
    def inputParallelism
        : Option[zio.aws.kinesisanalyticsv2.model.InputParallelism.ReadOnly]
    def inputSchema: zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly
    def getNamePrefix: ZIO[Any, Nothing, InAppStreamName] =
      ZIO.succeed(namePrefix)
    def getInputProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfiguration",
      inputProcessingConfiguration
    )
    def getKinesisStreamsInput: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsInput.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisStreamsInput", kinesisStreamsInput)
    def getKinesisFirehoseInput: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInput.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisFirehoseInput", kinesisFirehoseInput)
    def getInputParallelism: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputParallelism.ReadOnly
    ] = AwsError.unwrapOptionField("inputParallelism", inputParallelism)
    def getInputSchema: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly
    ] = ZIO.succeed(inputSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.Input
  ) extends zio.aws.kinesisanalyticsv2.model.Input.ReadOnly {
    override val namePrefix: InAppStreamName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .InAppStreamName(impl.namePrefix())
    override val inputProcessingConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly
    ] = scala
      .Option(impl.inputProcessingConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration
          .wrap(value)
      )
    override val kinesisStreamsInput: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsInput.ReadOnly
    ] = scala
      .Option(impl.kinesisStreamsInput())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.KinesisStreamsInput.wrap(value)
      )
    override val kinesisFirehoseInput: Option[
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInput.ReadOnly
    ] = scala
      .Option(impl.kinesisFirehoseInput())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInput.wrap(value)
      )
    override val inputParallelism
        : Option[zio.aws.kinesisanalyticsv2.model.InputParallelism.ReadOnly] =
      scala
        .Option(impl.inputParallelism())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.InputParallelism.wrap(value)
        )
    override val inputSchema
        : zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.SourceSchema.wrap(impl.inputSchema())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.Input
  ): zio.aws.kinesisanalyticsv2.model.Input.ReadOnly = new Wrapper(impl)
}
