package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  Id,
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteApplicationOutputRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    outputId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest = {
    import DeleteApplicationOutputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .outputId(Id.unwrap(outputId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationOutputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputRequest =
      zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputRequest(
        applicationName,
        currentApplicationVersionId,
        outputId
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def outputId: Id
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getOutputId: ZIO[Any, Nothing, Id] = ZIO.succeed(outputId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest
  ) extends zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val outputId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives.Id(impl.outputId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationOutputRequest
  ): zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputRequest.ReadOnly =
    new Wrapper(impl)
}
