package zio.aws.kinesisanalyticsv2.model
import scala.jdk.CollectionConverters.*
sealed trait RuntimeEnvironment {
  def unwrap: software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment
}
object RuntimeEnvironment {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment
  ): zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment = value match {
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.SQL_1_0 =>
      val r = `SQL-1_0`
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.FLINK_1_6 =>
      val r = `FLINK-1_6`
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.FLINK_1_8 =>
      val r = `FLINK-1_8`
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.ZEPPELIN_FLINK_1_0 =>
      val r = `ZEPPELIN-FLINK-1_0`
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.FLINK_1_11 =>
      val r = `FLINK-1_11`
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.FLINK_1_13 =>
      val r = `FLINK-1_13`
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.ZEPPELIN_FLINK_2_0 =>
      val r = `ZEPPELIN-FLINK-2_0`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.UNKNOWN_TO_SDK_VERSION
  }
  case object `SQL-1_0`
      extends zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.SQL_1_0
  }
  case object `FLINK-1_6`
      extends zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.FLINK_1_6
  }
  case object `FLINK-1_8`
      extends zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.FLINK_1_8
  }
  case object `ZEPPELIN-FLINK-1_0`
      extends zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.ZEPPELIN_FLINK_1_0
  }
  case object `FLINK-1_11`
      extends zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.FLINK_1_11
  }
  case object `FLINK-1_13`
      extends zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.FLINK_1_13
  }
  case object `ZEPPELIN-FLINK-2_0`
      extends zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.RuntimeEnvironment.ZEPPELIN_FLINK_2_0
  }
}
