package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.JobPlanDescription
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FlinkApplicationConfigurationDescription(
    checkpointConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription
    ] = None,
    monitoringConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription
    ] = None,
    parallelismConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription
    ] = None,
    jobPlanDescription: Option[JobPlanDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription = {
    import FlinkApplicationConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
      .builder()
      .optionallyWith(
        checkpointConfigurationDescription.map(value => value.buildAwsValue())
      )(_.checkpointConfigurationDescription)
      .optionallyWith(
        monitoringConfigurationDescription.map(value => value.buildAwsValue())
      )(_.monitoringConfigurationDescription)
      .optionallyWith(
        parallelismConfigurationDescription.map(value => value.buildAwsValue())
      )(_.parallelismConfigurationDescription)
      .optionallyWith(
        jobPlanDescription.map(value =>
          JobPlanDescription.unwrap(value): java.lang.String
        )
      )(_.jobPlanDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
      .wrap(buildAwsValue())
}
object FlinkApplicationConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription(
        checkpointConfigurationDescription.map(value => value.asEditable),
        monitoringConfigurationDescription.map(value => value.asEditable),
        parallelismConfigurationDescription.map(value => value.asEditable),
        jobPlanDescription.map(value => value)
      )
    def checkpointConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly
    ]
    def monitoringConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription.ReadOnly
    ]
    def parallelismConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly
    ]
    def jobPlanDescription: Option[JobPlanDescription]
    def getCheckpointConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "checkpointConfigurationDescription",
      checkpointConfigurationDescription
    )
    def getMonitoringConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringConfigurationDescription",
      monitoringConfigurationDescription
    )
    def getParallelismConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfigurationDescription",
      parallelismConfigurationDescription
    )
    def getJobPlanDescription: ZIO[Any, AwsError, JobPlanDescription] =
      AwsError.unwrapOptionField("jobPlanDescription", jobPlanDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription.ReadOnly {
    override val checkpointConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.checkpointConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription
          .wrap(value)
      )
    override val monitoringConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.monitoringConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription
          .wrap(value)
      )
    override val parallelismConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.parallelismConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription
          .wrap(value)
      )
    override val jobPlanDescription: Option[JobPlanDescription] = scala
      .Option(impl.jobPlanDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.JobPlanDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
