package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ConditionalToken,
  RoleARN,
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateApplicationRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: Option[ApplicationVersionId] = None,
    applicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
    ] = None,
    serviceExecutionRoleUpdate: Option[RoleARN] = None,
    runConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate
    ] = None,
    cloudWatchLoggingOptionUpdates: Option[
      Iterable[zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate]
    ] = None,
    conditionalToken: Option[ConditionalToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        currentApplicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.currentApplicationVersionId)
      .optionallyWith(
        applicationConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.applicationConfigurationUpdate)
      .optionallyWith(
        serviceExecutionRoleUpdate.map(value =>
          RoleARN.unwrap(value): java.lang.String
        )
      )(_.serviceExecutionRoleUpdate)
      .optionallyWith(
        runConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.runConfigurationUpdate)
      .optionallyWith(
        cloudWatchLoggingOptionUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchLoggingOptionUpdates)
      .optionallyWith(
        conditionalToken.map(value =>
          ConditionalToken.unwrap(value): java.lang.String
        )
      )(_.conditionalToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest
      .wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest =
      zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest(
        applicationName,
        currentApplicationVersionId.map(value => value),
        applicationConfigurationUpdate.map(value => value.asEditable),
        serviceExecutionRoleUpdate.map(value => value),
        runConfigurationUpdate.map(value => value.asEditable),
        cloudWatchLoggingOptionUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        conditionalToken.map(value => value)
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: Option[ApplicationVersionId]
    def applicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly
    ]
    def serviceExecutionRoleUpdate: Option[RoleARN]
    def runConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate.ReadOnly
    ]
    def cloudWatchLoggingOptionUpdates: Option[List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]]
    def conditionalToken: Option[ConditionalToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, AwsError, ApplicationVersionId] = AwsError.unwrapOptionField(
      "currentApplicationVersionId",
      currentApplicationVersionId
    )
    def getApplicationConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationConfigurationUpdate",
      applicationConfigurationUpdate
    )
    def getServiceExecutionRoleUpdate: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField(
        "serviceExecutionRoleUpdate",
        serviceExecutionRoleUpdate
      )
    def getRunConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "runConfigurationUpdate",
      runConfigurationUpdate
    )
    def getCloudWatchLoggingOptionUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptionUpdates",
      cloudWatchLoggingOptionUpdates
    )
    def getConditionalToken: ZIO[Any, AwsError, ConditionalToken] =
      AwsError.unwrapOptionField("conditionalToken", conditionalToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: Option[ApplicationVersionId] =
      scala
        .Option(impl.currentApplicationVersionId())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val applicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.applicationConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
          .wrap(value)
      )
    override val serviceExecutionRoleUpdate: Option[RoleARN] = scala
      .Option(impl.serviceExecutionRoleUpdate())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.RoleARN(value))
    override val runConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.runConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate.wrap(value)
      )
    override val cloudWatchLoggingOptionUpdates: Option[List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]] = scala
      .Option(impl.cloudWatchLoggingOptionUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate
            .wrap(item)
        }.toList
      )
    override val conditionalToken: Option[ConditionalToken] = scala
      .Option(impl.conditionalToken())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ConditionalToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest
  ): zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
