package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InputStartingPositionConfiguration(
    inputStartingPosition: Option[
      zio.aws.kinesisanalyticsv2.model.InputStartingPosition
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.InputStartingPositionConfiguration = {
    import InputStartingPositionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputStartingPositionConfiguration
      .builder()
      .optionallyWith(inputStartingPosition.map(value => value.unwrap))(
        _.inputStartingPosition
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration
      .wrap(buildAwsValue())
}
object InputStartingPositionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputStartingPositionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration =
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration(
        inputStartingPosition.map(value => value)
      )
    def inputStartingPosition
        : Option[zio.aws.kinesisanalyticsv2.model.InputStartingPosition]
    def getInputStartingPosition: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputStartingPosition
    ] =
      AwsError.unwrapOptionField("inputStartingPosition", inputStartingPosition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputStartingPositionConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly {
    override val inputStartingPosition
        : Option[zio.aws.kinesisanalyticsv2.model.InputStartingPosition] = scala
      .Option(impl.inputStartingPosition())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputStartingPosition.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputStartingPositionConfiguration
  ): zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly =
    new Wrapper(impl)
}
