package zio.aws.kinesisanalyticsv2
import zio.aws.kinesisanalyticsv2.model.primitives.BooleanObject.Type
import java.time.Instant
import zio.aws.kinesisanalyticsv2.model.primitives.{
  SubnetId,
  SecurityGroupId,
  PropertyKey,
  RawInputRecord,
  InAppStreamName,
  PropertyValue,
  ProcessedInputRecord,
  ParsedInputRecordField,
  TagKey
}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ApplicationDescription extends Subtype[String]
    type ApplicationDescription =
      zio.aws.kinesisanalyticsv2.model.primitives.ApplicationDescription.Type
    object ApplicationMaintenanceWindowEndTime extends Subtype[String]
    type ApplicationMaintenanceWindowEndTime =
      zio.aws.kinesisanalyticsv2.model.primitives.ApplicationMaintenanceWindowEndTime.Type
    object ApplicationMaintenanceWindowStartTime extends Subtype[String]
    type ApplicationMaintenanceWindowStartTime =
      zio.aws.kinesisanalyticsv2.model.primitives.ApplicationMaintenanceWindowStartTime.Type
    object ApplicationName extends Subtype[String]
    type ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives.ApplicationName.Type
    object ApplicationVersionId extends Subtype[Long]
    type ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives.ApplicationVersionId.Type
    object AuthorizedUrl extends Subtype[String]
    type AuthorizedUrl =
      zio.aws.kinesisanalyticsv2.model.primitives.AuthorizedUrl.Type
    object BasePath extends Subtype[String]
    type BasePath = zio.aws.kinesisanalyticsv2.model.primitives.BasePath.Type
    object BooleanObject extends Subtype[Boolean]
    type BooleanObject =
      zio.aws.kinesisanalyticsv2.model.primitives.BooleanObject.Type
    object BucketARN extends Subtype[String]
    type BucketARN = zio.aws.kinesisanalyticsv2.model.primitives.BucketARN.Type
    object CheckpointInterval extends Subtype[Long]
    type CheckpointInterval =
      zio.aws.kinesisanalyticsv2.model.primitives.CheckpointInterval.Type
    object CodeMD5 extends Subtype[String]
    type CodeMD5 = zio.aws.kinesisanalyticsv2.model.primitives.CodeMD5.Type
    object CodeSize extends Subtype[Long]
    type CodeSize = zio.aws.kinesisanalyticsv2.model.primitives.CodeSize.Type
    object ConditionalToken extends Subtype[String]
    type ConditionalToken =
      zio.aws.kinesisanalyticsv2.model.primitives.ConditionalToken.Type
    object DatabaseARN extends Subtype[String]
    type DatabaseARN =
      zio.aws.kinesisanalyticsv2.model.primitives.DatabaseARN.Type
    object FileKey extends Subtype[String]
    type FileKey = zio.aws.kinesisanalyticsv2.model.primitives.FileKey.Type
    object Id extends Subtype[String]
    type Id = zio.aws.kinesisanalyticsv2.model.primitives.Id.Type
    object InAppStreamName extends Subtype[String]
    type InAppStreamName =
      zio.aws.kinesisanalyticsv2.model.primitives.InAppStreamName.Type
    object InAppTableName extends Subtype[String]
    type InAppTableName =
      zio.aws.kinesisanalyticsv2.model.primitives.InAppTableName.Type
    object InputParallelismCount extends Subtype[Int]
    type InputParallelismCount =
      zio.aws.kinesisanalyticsv2.model.primitives.InputParallelismCount.Type
    object JobPlanDescription extends Subtype[String]
    type JobPlanDescription =
      zio.aws.kinesisanalyticsv2.model.primitives.JobPlanDescription.Type
    object KinesisAnalyticsARN extends Subtype[String]
    type KinesisAnalyticsARN =
      zio.aws.kinesisanalyticsv2.model.primitives.KinesisAnalyticsARN.Type
    object ListApplicationVersionsInputLimit extends Subtype[Int]
    type ListApplicationVersionsInputLimit =
      zio.aws.kinesisanalyticsv2.model.primitives.ListApplicationVersionsInputLimit.Type
    object ListApplicationsInputLimit extends Subtype[Int]
    type ListApplicationsInputLimit =
      zio.aws.kinesisanalyticsv2.model.primitives.ListApplicationsInputLimit.Type
    object ListSnapshotsInputLimit extends Subtype[Int]
    type ListSnapshotsInputLimit =
      zio.aws.kinesisanalyticsv2.model.primitives.ListSnapshotsInputLimit.Type
    object LogStreamARN extends Subtype[String]
    type LogStreamARN =
      zio.aws.kinesisanalyticsv2.model.primitives.LogStreamARN.Type
    object MavenArtifactId extends Subtype[String]
    type MavenArtifactId =
      zio.aws.kinesisanalyticsv2.model.primitives.MavenArtifactId.Type
    object MavenGroupId extends Subtype[String]
    type MavenGroupId =
      zio.aws.kinesisanalyticsv2.model.primitives.MavenGroupId.Type
    object MavenVersion extends Subtype[String]
    type MavenVersion =
      zio.aws.kinesisanalyticsv2.model.primitives.MavenVersion.Type
    object MinPauseBetweenCheckpoints extends Subtype[Long]
    type MinPauseBetweenCheckpoints =
      zio.aws.kinesisanalyticsv2.model.primitives.MinPauseBetweenCheckpoints.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.kinesisanalyticsv2.model.primitives.NextToken.Type
    object ObjectVersion extends Subtype[String]
    type ObjectVersion =
      zio.aws.kinesisanalyticsv2.model.primitives.ObjectVersion.Type
    object Parallelism extends Subtype[Int]
    type Parallelism =
      zio.aws.kinesisanalyticsv2.model.primitives.Parallelism.Type
    object ParallelismPerKPU extends Subtype[Int]
    type ParallelismPerKPU =
      zio.aws.kinesisanalyticsv2.model.primitives.ParallelismPerKPU.Type
    object ParsedInputRecordField extends Subtype[String]
    type ParsedInputRecordField =
      zio.aws.kinesisanalyticsv2.model.primitives.ParsedInputRecordField.Type
    object ProcessedInputRecord extends Subtype[String]
    type ProcessedInputRecord =
      zio.aws.kinesisanalyticsv2.model.primitives.ProcessedInputRecord.Type
    object PropertyKey extends Subtype[String]
    type PropertyKey =
      zio.aws.kinesisanalyticsv2.model.primitives.PropertyKey.Type
    object PropertyValue extends Subtype[String]
    type PropertyValue =
      zio.aws.kinesisanalyticsv2.model.primitives.PropertyValue.Type
    object RawInputRecord extends Subtype[String]
    type RawInputRecord =
      zio.aws.kinesisanalyticsv2.model.primitives.RawInputRecord.Type
    object RecordColumnDelimiter extends Subtype[String]
    type RecordColumnDelimiter =
      zio.aws.kinesisanalyticsv2.model.primitives.RecordColumnDelimiter.Type
    object RecordColumnMapping extends Subtype[String]
    type RecordColumnMapping =
      zio.aws.kinesisanalyticsv2.model.primitives.RecordColumnMapping.Type
    object RecordColumnName extends Subtype[String]
    type RecordColumnName =
      zio.aws.kinesisanalyticsv2.model.primitives.RecordColumnName.Type
    object RecordColumnSqlType extends Subtype[String]
    type RecordColumnSqlType =
      zio.aws.kinesisanalyticsv2.model.primitives.RecordColumnSqlType.Type
    object RecordEncoding extends Subtype[String]
    type RecordEncoding =
      zio.aws.kinesisanalyticsv2.model.primitives.RecordEncoding.Type
    object RecordRowDelimiter extends Subtype[String]
    type RecordRowDelimiter =
      zio.aws.kinesisanalyticsv2.model.primitives.RecordRowDelimiter.Type
    object RecordRowPath extends Subtype[String]
    type RecordRowPath =
      zio.aws.kinesisanalyticsv2.model.primitives.RecordRowPath.Type
    object ResourceARN extends Subtype[String]
    type ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN.Type
    object RoleARN extends Subtype[String]
    type RoleARN = zio.aws.kinesisanalyticsv2.model.primitives.RoleARN.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.kinesisanalyticsv2.model.primitives.SecurityGroupId.Type
    object SessionExpirationDurationInSeconds extends Subtype[Long]
    type SessionExpirationDurationInSeconds =
      zio.aws.kinesisanalyticsv2.model.primitives.SessionExpirationDurationInSeconds.Type
    object SnapshotName extends Subtype[String]
    type SnapshotName =
      zio.aws.kinesisanalyticsv2.model.primitives.SnapshotName.Type
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.kinesisanalyticsv2.model.primitives.SubnetId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.kinesisanalyticsv2.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.kinesisanalyticsv2.model.primitives.TagValue.Type
    object TextContent extends Subtype[String]
    type TextContent =
      zio.aws.kinesisanalyticsv2.model.primitives.TextContent.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.kinesisanalyticsv2.model.primitives.Timestamp.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.kinesisanalyticsv2.model.primitives.VpcId.Type
    object ZipFileContent extends Subtype[Chunk[Byte]]
    type ZipFileContent =
      zio.aws.kinesisanalyticsv2.model.primitives.ZipFileContent.Type
  }
  type ApplicationSummaries =
    List[zio.aws.kinesisanalyticsv2.model.ApplicationSummary]
  type ApplicationVersionSummaries =
    List[zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary]
  type CloudWatchLoggingOptionDescriptions =
    List[zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription]
  type CloudWatchLoggingOptionUpdates =
    List[zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate]
  type CloudWatchLoggingOptions =
    List[zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption]
  type CustomArtifactsConfigurationDescriptionList = List[
    zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
  ]
  type CustomArtifactsConfigurationList =
    List[zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration]
  type InAppStreamNames = List[InAppStreamName]
  type InputDescriptions =
    List[zio.aws.kinesisanalyticsv2.model.InputDescription]
  type InputUpdates = List[zio.aws.kinesisanalyticsv2.model.InputUpdate]
  type Inputs = List[zio.aws.kinesisanalyticsv2.model.Input]
  type OutputDescriptions =
    List[zio.aws.kinesisanalyticsv2.model.OutputDescription]
  type OutputUpdates = List[zio.aws.kinesisanalyticsv2.model.OutputUpdate]
  type Outputs = List[zio.aws.kinesisanalyticsv2.model.Output]
  type ParsedInputRecord = List[ParsedInputRecordField]
  type ParsedInputRecords = List[Iterable[ParsedInputRecordField]]
  type ProcessedInputRecords = List[ProcessedInputRecord]
  type PropertyGroups = List[zio.aws.kinesisanalyticsv2.model.PropertyGroup]
  type PropertyMap = Map[PropertyKey, PropertyValue]
  type RawInputRecords = List[RawInputRecord]
  type RecordColumns = List[zio.aws.kinesisanalyticsv2.model.RecordColumn]
  type ReferenceDataSourceDescriptions =
    List[zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription]
  type ReferenceDataSourceUpdates =
    List[zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceUpdate]
  type ReferenceDataSources =
    List[zio.aws.kinesisanalyticsv2.model.ReferenceDataSource]
  type SecurityGroupIds = List[SecurityGroupId]
  type SnapshotSummaries =
    List[zio.aws.kinesisanalyticsv2.model.SnapshotDetails]
  type SqlRunConfigurations =
    List[zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration]
  type SubnetIds = List[SubnetId]
  type TagKeys = List[TagKey]
  type Tags = List[zio.aws.kinesisanalyticsv2.model.Tag]
  type VpcConfigurationDescriptions =
    List[zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription]
  type VpcConfigurationUpdates =
    List[zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate]
  type VpcConfigurations =
    List[zio.aws.kinesisanalyticsv2.model.VpcConfiguration]
}
