package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RunConfigurationUpdate(
    flinkRunConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration
    ] = None,
    applicationRestoreConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationUpdate = {
    import RunConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationUpdate
      .builder()
      .optionallyWith(
        flinkRunConfiguration.map(value => value.buildAwsValue())
      )(_.flinkRunConfiguration)
      .optionallyWith(
        applicationRestoreConfiguration.map(value => value.buildAwsValue())
      )(_.applicationRestoreConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate
      .wrap(buildAwsValue())
}
object RunConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate(
        flinkRunConfiguration.map(value => value.asEditable),
        applicationRestoreConfiguration.map(value => value.asEditable)
      )
    def flinkRunConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly
    ]
    def applicationRestoreConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly
    ]
    def getFlinkRunConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("flinkRunConfiguration", flinkRunConfiguration)
    def getApplicationRestoreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationRestoreConfiguration",
      applicationRestoreConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate.ReadOnly {
    override val flinkRunConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly
    ] = scala
      .Option(impl.flinkRunConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.wrap(value)
      )
    override val applicationRestoreConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly
    ] = scala
      .Option(impl.applicationRestoreConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
