package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InputProcessingConfigurationDescription(
    inputLambdaProcessorDescription: Option[
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription = {
    import InputProcessingConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
      .builder()
      .optionallyWith(
        inputLambdaProcessorDescription.map(value => value.buildAwsValue())
      )(_.inputLambdaProcessorDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
      .wrap(buildAwsValue())
}
object InputProcessingConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription(
        inputLambdaProcessorDescription.map(value => value.asEditable)
      )
    def inputLambdaProcessorDescription: Option[
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription.ReadOnly
    ]
    def getInputLambdaProcessorDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputLambdaProcessorDescription",
      inputLambdaProcessorDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly {
    override val inputLambdaProcessorDescription: Option[
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription.ReadOnly
    ] = scala
      .Option(impl.inputLambdaProcessorDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
