package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{RoleARN, ResourceARN}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InputLambdaProcessorDescription(
    resourceARN: ResourceARN,
    roleARN: Option[RoleARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessorDescription = {
    import InputLambdaProcessorDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessorDescription
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription
      .wrap(buildAwsValue())
}
object InputLambdaProcessorDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessorDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription =
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription(
        resourceARN,
        roleARN.map(value => value)
      )
    def resourceARN: ResourceARN
    def roleARN: Option[RoleARN]
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessorDescription
  ) extends zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARN())
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessorDescription
  ): zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription.ReadOnly =
    new Wrapper(impl)
}
