package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InputLambdaProcessor(resourceARN: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessor = {
    import InputLambdaProcessor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessor
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.InputLambdaProcessor.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.InputLambdaProcessor.wrap(buildAwsValue())
}
object InputLambdaProcessor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.InputLambdaProcessor =
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessor(resourceARN)
    def resourceARN: ResourceARN
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessor
  ) extends zio.aws.kinesisanalyticsv2.model.InputLambdaProcessor.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputLambdaProcessor
  ): zio.aws.kinesisanalyticsv2.model.InputLambdaProcessor.ReadOnly =
    new Wrapper(impl)
}
