package zio.aws.kinesisanalyticsv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationName,
  ListApplicationsInputLimit
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListApplicationsRequest(
    limit: Option[ListApplicationsInputLimit] = None,
    nextToken: Option[ApplicationName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest = {
    import ListApplicationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListApplicationsInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ListApplicationsRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ListApplicationsRequest
      .wrap(buildAwsValue())
}
object ListApplicationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.ListApplicationsRequest =
      zio.aws.kinesisanalyticsv2.model.ListApplicationsRequest(
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Option[ListApplicationsInputLimit]
    def nextToken: Option[ApplicationName]
    def getLimit: ZIO[Any, AwsError, ListApplicationsInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest
  ) extends zio.aws.kinesisanalyticsv2.model.ListApplicationsRequest.ReadOnly {
    override val limit: Option[ListApplicationsInputLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives
          .ListApplicationsInputLimit(value)
      )
    override val nextToken: Option[ApplicationName] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ApplicationName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsRequest
  ): zio.aws.kinesisanalyticsv2.model.ListApplicationsRequest.ReadOnly =
    new Wrapper(impl)
}
