package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{RoleARN, ResourceARN}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DiscoverInputSchemaRequest(
    resourceARN: Option[ResourceARN] = None,
    serviceExecutionRole: RoleARN,
    inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration
    ] = None,
    s3Configuration: Option[zio.aws.kinesisanalyticsv2.model.S3Configuration] =
      None,
    inputProcessingConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest = {
    import DiscoverInputSchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
      .builder()
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .serviceExecutionRole(
        RoleARN.unwrap(serviceExecutionRole): java.lang.String
      )
      .optionallyWith(
        inputStartingPositionConfiguration.map(value => value.buildAwsValue())
      )(_.inputStartingPositionConfiguration)
      .optionallyWith(s3Configuration.map(value => value.buildAwsValue()))(
        _.s3Configuration
      )
      .optionallyWith(
        inputProcessingConfiguration.map(value => value.buildAwsValue())
      )(_.inputProcessingConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
      .wrap(buildAwsValue())
}
object DiscoverInputSchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest =
      zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest(
        resourceARN.map(value => value),
        serviceExecutionRole,
        inputStartingPositionConfiguration.map(value => value.asEditable),
        s3Configuration.map(value => value.asEditable),
        inputProcessingConfiguration.map(value => value.asEditable)
      )
    def resourceARN: Option[ResourceARN]
    def serviceExecutionRole: RoleARN
    def inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly
    ]
    def s3Configuration
        : Option[zio.aws.kinesisanalyticsv2.model.S3Configuration.ReadOnly]
    def inputProcessingConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly
    ]
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getServiceExecutionRole: ZIO[Any, Nothing, RoleARN] =
      ZIO.succeed(serviceExecutionRole)
    def getInputStartingPositionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputStartingPositionConfiguration",
      inputStartingPositionConfiguration
    )
    def getS3Configuration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.S3Configuration.ReadOnly
    ] = AwsError.unwrapOptionField("s3Configuration", s3Configuration)
    def getInputProcessingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfiguration",
      inputProcessingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
  ) extends zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest.ReadOnly {
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val serviceExecutionRole: RoleARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .RoleARN(impl.serviceExecutionRole())
    override val inputStartingPositionConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly
    ] = scala
      .Option(impl.inputStartingPositionConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration
          .wrap(value)
      )
    override val s3Configuration
        : Option[zio.aws.kinesisanalyticsv2.model.S3Configuration.ReadOnly] =
      scala
        .Option(impl.s3Configuration())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.S3Configuration.wrap(value)
        )
    override val inputProcessingConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration.ReadOnly
    ] = scala
      .Option(impl.inputProcessingConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputProcessingConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DiscoverInputSchemaRequest
  ): zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaRequest.ReadOnly =
    new Wrapper(impl)
}
