package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FlinkApplicationConfigurationUpdate(
    checkpointConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
    ] = None,
    monitoringConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
    ] = None,
    parallelismConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate = {
    import FlinkApplicationConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
      .builder()
      .optionallyWith(
        checkpointConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.checkpointConfigurationUpdate)
      .optionallyWith(
        monitoringConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.monitoringConfigurationUpdate)
      .optionallyWith(
        parallelismConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.parallelismConfigurationUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
      .wrap(buildAwsValue())
}
object FlinkApplicationConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate(
        checkpointConfigurationUpdate.map(value => value.asEditable),
        monitoringConfigurationUpdate.map(value => value.asEditable),
        parallelismConfigurationUpdate.map(value => value.asEditable)
      )
    def checkpointConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly
    ]
    def monitoringConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly
    ]
    def parallelismConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate.ReadOnly
    ]
    def getCheckpointConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "checkpointConfigurationUpdate",
      checkpointConfigurationUpdate
    )
    def getMonitoringConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringConfigurationUpdate",
      monitoringConfigurationUpdate
    )
    def getParallelismConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfigurationUpdate",
      parallelismConfigurationUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly {
    override val checkpointConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.checkpointConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationUpdate
          .wrap(value)
      )
    override val monitoringConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.monitoringConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationUpdate
          .wrap(value)
      )
    override val parallelismConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.parallelismConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationUpdate
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
