package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  Id,
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteApplicationReferenceDataSourceRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: ApplicationVersionId,
    referenceId: Id
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest = {
    import DeleteApplicationReferenceDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .currentApplicationVersionId(
        ApplicationVersionId.unwrap(currentApplicationVersionId): java.lang.Long
      )
      .referenceId(Id.unwrap(referenceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationReferenceDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest =
      zio.aws.kinesisanalyticsv2.model
        .DeleteApplicationReferenceDataSourceRequest(
          applicationName,
          currentApplicationVersionId,
          referenceId
        )
    def applicationName: ApplicationName
    def currentApplicationVersionId: ApplicationVersionId
    def referenceId: Id
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(currentApplicationVersionId)
    def getReferenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(referenceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest
  ) extends zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.currentApplicationVersionId())
    override val referenceId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives.Id(impl.referenceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest
  ): zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceRequest.ReadOnly =
    new Wrapper(impl)
}
