package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  CodeSize,
  CodeMD5,
  TextContent
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CodeContentDescription(
    textContent: Option[TextContent] = None,
    codeMD5: Option[CodeMD5] = None,
    codeSize: Option[CodeSize] = None,
    s3ApplicationCodeLocationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentDescription = {
    import CodeContentDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentDescription
      .builder()
      .optionallyWith(
        textContent.map(value => TextContent.unwrap(value): java.lang.String)
      )(_.textContent)
      .optionallyWith(
        codeMD5.map(value => CodeMD5.unwrap(value): java.lang.String)
      )(_.codeMD5)
      .optionallyWith(
        codeSize.map(value => CodeSize.unwrap(value): java.lang.Long)
      )(_.codeSize)
      .optionallyWith(
        s3ApplicationCodeLocationDescription.map(value => value.buildAwsValue())
      )(_.s3ApplicationCodeLocationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CodeContentDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CodeContentDescription
      .wrap(buildAwsValue())
}
object CodeContentDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.CodeContentDescription =
      zio.aws.kinesisanalyticsv2.model.CodeContentDescription(
        textContent.map(value => value),
        codeMD5.map(value => value),
        codeSize.map(value => value),
        s3ApplicationCodeLocationDescription.map(value => value.asEditable)
      )
    def textContent: Option[TextContent]
    def codeMD5: Option[CodeMD5]
    def codeSize: Option[CodeSize]
    def s3ApplicationCodeLocationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription.ReadOnly
    ]
    def getTextContent: ZIO[Any, AwsError, TextContent] =
      AwsError.unwrapOptionField("textContent", textContent)
    def getCodeMD5: ZIO[Any, AwsError, CodeMD5] =
      AwsError.unwrapOptionField("codeMD5", codeMD5)
    def getCodeSize: ZIO[Any, AwsError, CodeSize] =
      AwsError.unwrapOptionField("codeSize", codeSize)
    def getS3ApplicationCodeLocationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3ApplicationCodeLocationDescription",
      s3ApplicationCodeLocationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentDescription
  ) extends zio.aws.kinesisanalyticsv2.model.CodeContentDescription.ReadOnly {
    override val textContent: Option[TextContent] = scala
      .Option(impl.textContent())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.TextContent(value)
      )
    override val codeMD5: Option[CodeMD5] = scala
      .Option(impl.codeMD5())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.CodeMD5(value))
    override val codeSize: Option[CodeSize] = scala
      .Option(impl.codeSize())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.CodeSize(value))
    override val s3ApplicationCodeLocationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription.ReadOnly
    ] = scala
      .Option(impl.s3ApplicationCodeLocationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.S3ApplicationCodeLocationDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentDescription
  ): zio.aws.kinesisanalyticsv2.model.CodeContentDescription.ReadOnly =
    new Wrapper(impl)
}
