package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ConditionalToken,
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddApplicationCloudWatchLoggingOptionRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: Option[ApplicationVersionId] = None,
    cloudWatchLoggingOption: zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption,
    conditionalToken: Option[ConditionalToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest = {
    import AddApplicationCloudWatchLoggingOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        currentApplicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.currentApplicationVersionId)
      .cloudWatchLoggingOption(cloudWatchLoggingOption.buildAwsValue())
      .optionallyWith(
        conditionalToken.map(value =>
          ConditionalToken.unwrap(value): java.lang.String
        )
      )(_.conditionalToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest
      .wrap(buildAwsValue())
}
object AddApplicationCloudWatchLoggingOptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest =
      zio.aws.kinesisanalyticsv2.model
        .AddApplicationCloudWatchLoggingOptionRequest(
          applicationName,
          currentApplicationVersionId.map(value => value),
          cloudWatchLoggingOption.asEditable,
          conditionalToken.map(value => value)
        )
    def applicationName: ApplicationName
    def currentApplicationVersionId: Option[ApplicationVersionId]
    def cloudWatchLoggingOption
        : zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption.ReadOnly
    def conditionalToken: Option[ConditionalToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, AwsError, ApplicationVersionId] = AwsError.unwrapOptionField(
      "currentApplicationVersionId",
      currentApplicationVersionId
    )
    def getCloudWatchLoggingOption: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption.ReadOnly
    ] = ZIO.succeed(cloudWatchLoggingOption)
    def getConditionalToken: ZIO[Any, AwsError, ConditionalToken] =
      AwsError.unwrapOptionField("conditionalToken", conditionalToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: Option[ApplicationVersionId] =
      scala
        .Option(impl.currentApplicationVersionId())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val cloudWatchLoggingOption
        : zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption
        .wrap(impl.cloudWatchLoggingOption())
    override val conditionalToken: Option[ConditionalToken] = scala
      .Option(impl.conditionalToken())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ConditionalToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionRequest.ReadOnly =
    new Wrapper(impl)
}
