package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{RoleARN, FileKey, BucketARN}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class S3ReferenceDataSourceDescription(
    bucketARN: BucketARN,
    fileKey: FileKey,
    referenceRoleARN: Option[RoleARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription = {
    import S3ReferenceDataSourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription
      .builder()
      .bucketARN(BucketARN.unwrap(bucketARN): java.lang.String)
      .fileKey(FileKey.unwrap(fileKey): java.lang.String)
      .optionallyWith(
        referenceRoleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.referenceRoleARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription
      .wrap(buildAwsValue())
}
object S3ReferenceDataSourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription =
      zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription(
        bucketARN,
        fileKey,
        referenceRoleARN.map(value => value)
      )
    def bucketARN: BucketARN
    def fileKey: FileKey
    def referenceRoleARN: Option[RoleARN]
    def getBucketARN: ZIO[Any, Nothing, BucketARN] = ZIO.succeed(bucketARN)
    def getFileKey: ZIO[Any, Nothing, FileKey] = ZIO.succeed(fileKey)
    def getReferenceRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("referenceRoleARN", referenceRoleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription
  ) extends zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription.ReadOnly {
    override val bucketARN: BucketARN =
      zio.aws.kinesisanalyticsv2.model.primitives.BucketARN(impl.bucketARN())
    override val fileKey: FileKey =
      zio.aws.kinesisanalyticsv2.model.primitives.FileKey(impl.fileKey())
    override val referenceRoleARN: Option[RoleARN] = scala
      .Option(impl.referenceRoleARN())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription
  ): zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription.ReadOnly =
    new Wrapper(impl)
}
