package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MonitoringConfiguration(
    configurationType: zio.aws.kinesisanalyticsv2.model.ConfigurationType,
    metricsLevel: Option[zio.aws.kinesisanalyticsv2.model.MetricsLevel] = None,
    logLevel: Option[zio.aws.kinesisanalyticsv2.model.LogLevel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfiguration = {
    import MonitoringConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfiguration
      .builder()
      .configurationType(configurationType.unwrap)
      .optionallyWith(metricsLevel.map(value => value.unwrap))(_.metricsLevel)
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.MonitoringConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.MonitoringConfiguration
      .wrap(buildAwsValue())
}
object MonitoringConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.MonitoringConfiguration =
      zio.aws.kinesisanalyticsv2.model.MonitoringConfiguration(
        configurationType,
        metricsLevel.map(value => value),
        logLevel.map(value => value)
      )
    def configurationType: zio.aws.kinesisanalyticsv2.model.ConfigurationType
    def metricsLevel: Option[zio.aws.kinesisanalyticsv2.model.MetricsLevel]
    def logLevel: Option[zio.aws.kinesisanalyticsv2.model.LogLevel]
    def getConfigurationType: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = ZIO.succeed(configurationType)
    def getMetricsLevel
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.MetricsLevel] =
      AwsError.unwrapOptionField("metricsLevel", metricsLevel)
    def getLogLevel
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.MonitoringConfiguration.ReadOnly {
    override val configurationType
        : zio.aws.kinesisanalyticsv2.model.ConfigurationType =
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
        .wrap(impl.configurationType())
    override val metricsLevel
        : Option[zio.aws.kinesisanalyticsv2.model.MetricsLevel] = scala
      .Option(impl.metricsLevel())
      .map(value => zio.aws.kinesisanalyticsv2.model.MetricsLevel.wrap(value))
    override val logLevel: Option[zio.aws.kinesisanalyticsv2.model.LogLevel] =
      scala
        .Option(impl.logLevel())
        .map(value => zio.aws.kinesisanalyticsv2.model.LogLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfiguration
  ): zio.aws.kinesisanalyticsv2.model.MonitoringConfiguration.ReadOnly =
    new Wrapper(impl)
}
