package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.KinesisAnalyticsARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceARN: KinesisAnalyticsARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(KinesisAnalyticsARN.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ListTagsForResourceRequest =
      zio.aws.kinesisanalyticsv2.model.ListTagsForResourceRequest(resourceARN)
    def resourceARN: KinesisAnalyticsARN
    def getResourceARN: ZIO[Any, Nothing, KinesisAnalyticsARN] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest
  ) extends zio.aws.kinesisanalyticsv2.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: KinesisAnalyticsARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .KinesisAnalyticsARN(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListTagsForResourceRequest
  ): zio.aws.kinesisanalyticsv2.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
