package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ConditionalToken,
  Id,
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteApplicationVpcConfigurationRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: Option[ApplicationVersionId] = None,
    vpcConfigurationId: Id,
    conditionalToken: Option[ConditionalToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest = {
    import DeleteApplicationVpcConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        currentApplicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.currentApplicationVersionId)
      .vpcConfigurationId(Id.unwrap(vpcConfigurationId): java.lang.String)
      .optionallyWith(
        conditionalToken.map(value =>
          ConditionalToken.unwrap(value): java.lang.String
        )
      )(_.conditionalToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationVpcConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest =
      zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest(
        applicationName,
        currentApplicationVersionId.map(value => value),
        vpcConfigurationId,
        conditionalToken.map(value => value)
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: Option[ApplicationVersionId]
    def vpcConfigurationId: Id
    def conditionalToken: Option[ConditionalToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, AwsError, ApplicationVersionId] = AwsError.unwrapOptionField(
      "currentApplicationVersionId",
      currentApplicationVersionId
    )
    def getVpcConfigurationId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(vpcConfigurationId)
    def getConditionalToken: ZIO[Any, AwsError, ConditionalToken] =
      AwsError.unwrapOptionField("conditionalToken", conditionalToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: Option[ApplicationVersionId] =
      scala
        .Option(impl.currentApplicationVersionId())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val vpcConfigurationId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives.Id(impl.vpcConfigurationId())
    override val conditionalToken: Option[ConditionalToken] = scala
      .Option(impl.conditionalToken())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ConditionalToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest
  ): zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
