package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.AuthorizedUrl
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateApplicationPresignedUrlResponse(
    authorizedUrl: Option[AuthorizedUrl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse = {
    import CreateApplicationPresignedUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse
      .builder()
      .optionallyWith(
        authorizedUrl.map(value =>
          AuthorizedUrl.unwrap(value): java.lang.String
        )
      )(_.authorizedUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse
      .wrap(buildAwsValue())
}
object CreateApplicationPresignedUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse =
      zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse(
        authorizedUrl.map(value => value)
      )
    def authorizedUrl: Option[AuthorizedUrl]
    def getAuthorizedUrl: ZIO[Any, AwsError, AuthorizedUrl] =
      AwsError.unwrapOptionField("authorizedUrl", authorizedUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse
  ) extends zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse.ReadOnly {
    override val authorizedUrl: Option[AuthorizedUrl] = scala
      .Option(impl.authorizedUrl())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.AuthorizedUrl(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse
  ): zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse.ReadOnly =
    new Wrapper(impl)
}
