package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{ZipFileContent, TextContent}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CodeContentUpdate(
    textContentUpdate: Option[TextContent] = None,
    zipFileContentUpdate: Option[ZipFileContent] = None,
    s3ContentLocationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.S3ContentLocationUpdate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentUpdate = {
    import CodeContentUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentUpdate
      .builder()
      .optionallyWith(
        textContentUpdate.map(value =>
          TextContent.unwrap(value): java.lang.String
        )
      )(_.textContentUpdate)
      .optionallyWith(
        zipFileContentUpdate.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.zipFileContentUpdate)
      .optionallyWith(
        s3ContentLocationUpdate.map(value => value.buildAwsValue())
      )(_.s3ContentLocationUpdate)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.wrap(buildAwsValue())
}
object CodeContentUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.CodeContentUpdate =
      zio.aws.kinesisanalyticsv2.model.CodeContentUpdate(
        textContentUpdate.map(value => value),
        zipFileContentUpdate.map(value => value),
        s3ContentLocationUpdate.map(value => value.asEditable)
      )
    def textContentUpdate: Option[TextContent]
    def zipFileContentUpdate: Option[ZipFileContent]
    def s3ContentLocationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.S3ContentLocationUpdate.ReadOnly
    ]
    def getTextContentUpdate: ZIO[Any, AwsError, TextContent] =
      AwsError.unwrapOptionField("textContentUpdate", textContentUpdate)
    def getZipFileContentUpdate: ZIO[Any, AwsError, ZipFileContent] =
      AwsError.unwrapOptionField("zipFileContentUpdate", zipFileContentUpdate)
    def getS3ContentLocationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.S3ContentLocationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3ContentLocationUpdate",
      s3ContentLocationUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.ReadOnly {
    override val textContentUpdate: Option[TextContent] = scala
      .Option(impl.textContentUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.TextContent(value)
      )
    override val zipFileContentUpdate: Option[ZipFileContent] = scala
      .Option(impl.zipFileContentUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives
          .ZipFileContent(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val s3ContentLocationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.S3ContentLocationUpdate.ReadOnly
    ] = scala
      .Option(impl.s3ContentLocationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.S3ContentLocationUpdate.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CodeContentUpdate
  ): zio.aws.kinesisanalyticsv2.model.CodeContentUpdate.ReadOnly = new Wrapper(
    impl
  )
}
