package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  Id,
  ApplicationVersionId,
  ResourceARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddApplicationInputProcessingConfigurationResponse(
    applicationARN: Option[ResourceARN] = None,
    applicationVersionId: Option[ApplicationVersionId] = None,
    inputId: Option[Id] = None,
    inputProcessingConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse = {
    import AddApplicationInputProcessingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionId)
      .optionallyWith(inputId.map(value => Id.unwrap(value): java.lang.String))(
        _.inputId
      )
      .optionallyWith(
        inputProcessingConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.inputProcessingConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse
      .wrap(buildAwsValue())
}
object AddApplicationInputProcessingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse =
      zio.aws.kinesisanalyticsv2.model
        .AddApplicationInputProcessingConfigurationResponse(
          applicationARN.map(value => value),
          applicationVersionId.map(value => value),
          inputId.map(value => value),
          inputProcessingConfigurationDescription.map(value => value.asEditable)
        )
    def applicationARN: Option[ResourceARN]
    def applicationVersionId: Option[ApplicationVersionId]
    def inputId: Option[Id]
    def inputProcessingConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly
    ]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationVersionId: ZIO[Any, AwsError, ApplicationVersionId] =
      AwsError.unwrapOptionField("applicationVersionId", applicationVersionId)
    def getInputId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("inputId", inputId)
    def getInputProcessingConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfigurationDescription",
      inputProcessingConfigurationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly {
    override val applicationARN: Option[ResourceARN] = scala
      .Option(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationVersionId: Option[ApplicationVersionId] = scala
      .Option(impl.applicationVersionId())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ApplicationVersionId(value)
      )
    override val inputId: Option[Id] = scala
      .Option(impl.inputId())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.Id(value))
    override val inputProcessingConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly
    ] = scala
      .Option(impl.inputProcessingConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
