package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RunConfigurationDescription(
    applicationRestoreConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration
    ] = None,
    flinkRunConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationDescription = {
    import RunConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationDescription
      .builder()
      .optionallyWith(
        applicationRestoreConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.applicationRestoreConfigurationDescription)
      .optionallyWith(
        flinkRunConfigurationDescription.map(value => value.buildAwsValue())
      )(_.flinkRunConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.RunConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.RunConfigurationDescription
      .wrap(buildAwsValue())
}
object RunConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.RunConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.RunConfigurationDescription(
        applicationRestoreConfigurationDescription.map(value =>
          value.asEditable
        ),
        flinkRunConfigurationDescription.map(value => value.asEditable)
      )
    def applicationRestoreConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly
    ]
    def flinkRunConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly
    ]
    def getApplicationRestoreConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationRestoreConfigurationDescription",
      applicationRestoreConfigurationDescription
    )
    def getFlinkRunConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "flinkRunConfigurationDescription",
      flinkRunConfigurationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.RunConfigurationDescription.ReadOnly {
    override val applicationRestoreConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly
    ] = scala
      .Option(impl.applicationRestoreConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration
          .wrap(value)
      )
    override val flinkRunConfigurationDescription: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly
    ] = scala
      .Option(impl.flinkRunConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.RunConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
