package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ResourceARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddApplicationCloudWatchLoggingOptionResponse(
    applicationARN: Option[ResourceARN] = None,
    applicationVersionId: Option[ApplicationVersionId] = None,
    cloudWatchLoggingOptionDescriptions: Option[Iterable[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse = {
    import AddApplicationCloudWatchLoggingOptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionId)
      .optionallyWith(
        cloudWatchLoggingOptionDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchLoggingOptionDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse
      .wrap(buildAwsValue())
}
object AddApplicationCloudWatchLoggingOptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse =
      zio.aws.kinesisanalyticsv2.model
        .AddApplicationCloudWatchLoggingOptionResponse(
          applicationARN.map(value => value),
          applicationVersionId.map(value => value),
          cloudWatchLoggingOptionDescriptions.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def applicationARN: Option[ResourceARN]
    def applicationVersionId: Option[ApplicationVersionId]
    def cloudWatchLoggingOptionDescriptions: Option[List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationVersionId: ZIO[Any, AwsError, ApplicationVersionId] =
      AwsError.unwrapOptionField("applicationVersionId", applicationVersionId)
    def getCloudWatchLoggingOptionDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptionDescriptions",
      cloudWatchLoggingOptionDescriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly {
    override val applicationARN: Option[ResourceARN] = scala
      .Option(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationVersionId: Option[ApplicationVersionId] = scala
      .Option(impl.applicationVersionId())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ApplicationVersionId(value)
      )
    override val cloudWatchLoggingOptionDescriptions: Option[List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]] = scala
      .Option(impl.cloudWatchLoggingOptionDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly =
    new Wrapper(impl)
}
