package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.RecordRowPath
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class JSONMappingParameters(recordRowPath: RecordRowPath) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.JSONMappingParameters = {
    import JSONMappingParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.JSONMappingParameters
      .builder()
      .recordRowPath(RecordRowPath.unwrap(recordRowPath): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.JSONMappingParameters.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.JSONMappingParameters.wrap(buildAwsValue())
}
object JSONMappingParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.JSONMappingParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.JSONMappingParameters =
      zio.aws.kinesisanalyticsv2.model.JSONMappingParameters(recordRowPath)
    def recordRowPath: RecordRowPath
    def getRecordRowPath: ZIO[Any, Nothing, RecordRowPath] =
      ZIO.succeed(recordRowPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.JSONMappingParameters
  ) extends zio.aws.kinesisanalyticsv2.model.JSONMappingParameters.ReadOnly {
    override val recordRowPath: RecordRowPath =
      zio.aws.kinesisanalyticsv2.model.primitives
        .RecordRowPath(impl.recordRowPath())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.JSONMappingParameters
  ): zio.aws.kinesisanalyticsv2.model.JSONMappingParameters.ReadOnly =
    new Wrapper(impl)
}
