package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ConditionalToken,
  RoleARN,
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateApplicationRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: Optional[ApplicationVersionId] =
      Optional.Absent,
    applicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
    ] = Optional.Absent,
    serviceExecutionRoleUpdate: Optional[RoleARN] = Optional.Absent,
    runConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate
    ] = Optional.Absent,
    cloudWatchLoggingOptionUpdates: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate]
    ] = Optional.Absent,
    conditionalToken: Optional[ConditionalToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        currentApplicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.currentApplicationVersionId)
      .optionallyWith(
        applicationConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.applicationConfigurationUpdate)
      .optionallyWith(
        serviceExecutionRoleUpdate.map(value =>
          RoleARN.unwrap(value): java.lang.String
        )
      )(_.serviceExecutionRoleUpdate)
      .optionallyWith(
        runConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.runConfigurationUpdate)
      .optionallyWith(
        cloudWatchLoggingOptionUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchLoggingOptionUpdates)
      .optionallyWith(
        conditionalToken.map(value =>
          ConditionalToken.unwrap(value): java.lang.String
        )
      )(_.conditionalToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest
      .wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest =
      zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest(
        applicationName,
        currentApplicationVersionId.map(value => value),
        applicationConfigurationUpdate.map(value => value.asEditable),
        serviceExecutionRoleUpdate.map(value => value),
        runConfigurationUpdate.map(value => value.asEditable),
        cloudWatchLoggingOptionUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        conditionalToken.map(value => value)
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: Optional[ApplicationVersionId]
    def applicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly
    ]
    def serviceExecutionRoleUpdate: Optional[RoleARN]
    def runConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate.ReadOnly
    ]
    def cloudWatchLoggingOptionUpdates: Optional[List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]]
    def conditionalToken: Optional[ConditionalToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, AwsError, ApplicationVersionId] = AwsError.unwrapOptionField(
      "currentApplicationVersionId",
      currentApplicationVersionId
    )
    def getApplicationConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationConfigurationUpdate",
      applicationConfigurationUpdate
    )
    def getServiceExecutionRoleUpdate: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField(
        "serviceExecutionRoleUpdate",
        serviceExecutionRoleUpdate
      )
    def getRunConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "runConfigurationUpdate",
      runConfigurationUpdate
    )
    def getCloudWatchLoggingOptionUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptionUpdates",
      cloudWatchLoggingOptionUpdates
    )
    def getConditionalToken: ZIO[Any, AwsError, ConditionalToken] =
      AwsError.unwrapOptionField("conditionalToken", conditionalToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: Optional[ApplicationVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentApplicationVersionId())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val applicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
          .wrap(value)
      )
    override val serviceExecutionRoleUpdate: Optional[RoleARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceExecutionRoleUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.RoleARN(value)
        )
    override val runConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.runConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.RunConfigurationUpdate.wrap(value)
      )
    override val cloudWatchLoggingOptionUpdates: Optional[List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLoggingOptionUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionUpdate
            .wrap(item)
        }.toList
      )
    override val conditionalToken: Optional[ConditionalToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionalToken())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.ConditionalToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationRequest
  ): zio.aws.kinesisanalyticsv2.model.UpdateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
