package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  RoleARN,
  ApplicationDescription,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateApplicationRequest(
    applicationName: ApplicationName,
    applicationDescription: Optional[ApplicationDescription] = Optional.Absent,
    runtimeEnvironment: zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment,
    serviceExecutionRole: RoleARN,
    applicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfiguration
    ] = Optional.Absent,
    cloudWatchLoggingOptions: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.kinesisanalyticsv2.model.Tag]] =
      Optional.Absent,
    applicationMode: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationMode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        applicationDescription.map(value =>
          ApplicationDescription.unwrap(value): java.lang.String
        )
      )(_.applicationDescription)
      .runtimeEnvironment(runtimeEnvironment.unwrap)
      .serviceExecutionRole(
        RoleARN.unwrap(serviceExecutionRole): java.lang.String
      )
      .optionallyWith(
        applicationConfiguration.map(value => value.buildAwsValue())
      )(_.applicationConfiguration)
      .optionallyWith(
        cloudWatchLoggingOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchLoggingOptions)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(applicationMode.map(value => value.unwrap))(
        _.applicationMode
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CreateApplicationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CreateApplicationRequest
      .wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.CreateApplicationRequest =
      zio.aws.kinesisanalyticsv2.model.CreateApplicationRequest(
        applicationName,
        applicationDescription.map(value => value),
        runtimeEnvironment,
        serviceExecutionRole,
        applicationConfiguration.map(value => value.asEditable),
        cloudWatchLoggingOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationMode.map(value => value)
      )
    def applicationName: ApplicationName
    def applicationDescription: Optional[ApplicationDescription]
    def runtimeEnvironment: zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment
    def serviceExecutionRole: RoleARN
    def applicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfiguration.ReadOnly
    ]
    def cloudWatchLoggingOptions: Optional[
      List[zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption.ReadOnly]
    ]
    def tags: Optional[List[zio.aws.kinesisanalyticsv2.model.Tag.ReadOnly]]
    def applicationMode
        : Optional[zio.aws.kinesisanalyticsv2.model.ApplicationMode]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getApplicationDescription: ZIO[Any, AwsError, ApplicationDescription] =
      AwsError.unwrapOptionField(
        "applicationDescription",
        applicationDescription
      )
    def getRuntimeEnvironment: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment
    ] = ZIO.succeed(runtimeEnvironment)
    def getServiceExecutionRole: ZIO[Any, Nothing, RoleARN] =
      ZIO.succeed(serviceExecutionRole)
    def getApplicationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationConfiguration",
      applicationConfiguration
    )
    def getCloudWatchLoggingOptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptions",
      cloudWatchLoggingOptions
    )
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getApplicationMode
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.ApplicationMode] =
      AwsError.unwrapOptionField("applicationMode", applicationMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.CreateApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val applicationDescription: Optional[ApplicationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationDescription())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationDescription(value)
        )
    override val runtimeEnvironment
        : zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment =
      zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment
        .wrap(impl.runtimeEnvironment())
    override val serviceExecutionRole: RoleARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .RoleARN(impl.serviceExecutionRole())
    override val applicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationConfiguration.wrap(value)
      )
    override val cloudWatchLoggingOptions: Optional[
      List[zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLoggingOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption.wrap(item)
        }.toList
      )
    override val tags
        : Optional[List[zio.aws.kinesisanalyticsv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalyticsv2.model.Tag.wrap(item)
          }.toList
        )
    override val applicationMode
        : Optional[zio.aws.kinesisanalyticsv2.model.ApplicationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationMode())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.ApplicationMode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationRequest
  ): zio.aws.kinesisanalyticsv2.model.CreateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
