package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ConditionalToken,
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddApplicationVpcConfigurationRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: Optional[ApplicationVersionId] =
      Optional.Absent,
    vpcConfiguration: zio.aws.kinesisanalyticsv2.model.VpcConfiguration,
    conditionalToken: Optional[ConditionalToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest = {
    import AddApplicationVpcConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        currentApplicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.currentApplicationVersionId)
      .vpcConfiguration(vpcConfiguration.buildAwsValue())
      .optionallyWith(
        conditionalToken.map(value =>
          ConditionalToken.unwrap(value): java.lang.String
        )
      )(_.conditionalToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest
      .wrap(buildAwsValue())
}
object AddApplicationVpcConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest =
      zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest(
        applicationName,
        currentApplicationVersionId.map(value => value),
        vpcConfiguration.asEditable,
        conditionalToken.map(value => value)
      )
    def applicationName: ApplicationName
    def currentApplicationVersionId: Optional[ApplicationVersionId]
    def vpcConfiguration
        : zio.aws.kinesisanalyticsv2.model.VpcConfiguration.ReadOnly
    def conditionalToken: Optional[ConditionalToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, AwsError, ApplicationVersionId] = AwsError.unwrapOptionField(
      "currentApplicationVersionId",
      currentApplicationVersionId
    )
    def getVpcConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.VpcConfiguration.ReadOnly
    ] = ZIO.succeed(vpcConfiguration)
    def getConditionalToken: ZIO[Any, AwsError, ConditionalToken] =
      AwsError.unwrapOptionField("conditionalToken", conditionalToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: Optional[ApplicationVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentApplicationVersionId())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val vpcConfiguration
        : zio.aws.kinesisanalyticsv2.model.VpcConfiguration.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.VpcConfiguration
        .wrap(impl.vpcConfiguration())
    override val conditionalToken: Optional[ConditionalToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionalToken())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.ConditionalToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
