package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  Id,
  ApplicationVersionId,
  ResourceARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddApplicationInputProcessingConfigurationResponse(
    applicationARN: Optional[ResourceARN] = Optional.Absent,
    applicationVersionId: Optional[ApplicationVersionId] = Optional.Absent,
    inputId: Optional[Id] = Optional.Absent,
    inputProcessingConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse = {
    import AddApplicationInputProcessingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionId)
      .optionallyWith(inputId.map(value => Id.unwrap(value): java.lang.String))(
        _.inputId
      )
      .optionallyWith(
        inputProcessingConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.inputProcessingConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse
      .wrap(buildAwsValue())
}
object AddApplicationInputProcessingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse =
      zio.aws.kinesisanalyticsv2.model
        .AddApplicationInputProcessingConfigurationResponse(
          applicationARN.map(value => value),
          applicationVersionId.map(value => value),
          inputId.map(value => value),
          inputProcessingConfigurationDescription.map(value => value.asEditable)
        )
    def applicationARN: Optional[ResourceARN]
    def applicationVersionId: Optional[ApplicationVersionId]
    def inputId: Optional[Id]
    def inputProcessingConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly
    ]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationVersionId: ZIO[Any, AwsError, ApplicationVersionId] =
      AwsError.unwrapOptionField("applicationVersionId", applicationVersionId)
    def getInputId: ZIO[Any, AwsError, Id] =
      AwsError.unwrapOptionField("inputId", inputId)
    def getInputProcessingConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputProcessingConfigurationDescription",
      inputProcessingConfigurationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly {
    override val applicationARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationVersionId: Optional[ApplicationVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationVersionId())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val inputId: Optional[Id] = zio.aws.core.internal
      .optionalFromNullable(impl.inputId())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.Id(value))
    override val inputProcessingConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputProcessingConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
