package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateApplicationMaintenanceConfigurationResponse(
    applicationARN: Optional[ResourceARN] = Optional.Absent,
    applicationMaintenanceConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse = {
    import UpdateApplicationMaintenanceConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationMaintenanceConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.applicationMaintenanceConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse
      .wrap(buildAwsValue())
}
object UpdateApplicationMaintenanceConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse =
      zio.aws.kinesisanalyticsv2.model
        .UpdateApplicationMaintenanceConfigurationResponse(
          applicationARN.map(value => value),
          applicationMaintenanceConfigurationDescription.map(value =>
            value.asEditable
          )
        )
    def applicationARN: Optional[ResourceARN]
    def applicationMaintenanceConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription.ReadOnly
    ]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationMaintenanceConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationMaintenanceConfigurationDescription",
      applicationMaintenanceConfigurationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse
  ) extends zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse.ReadOnly {
    override val applicationARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationMaintenanceConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.applicationMaintenanceConfigurationDescription()
      )
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse
  ): zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
