package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KinesisFirehoseOutputUpdate(resourceARNUpdate: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate = {
    import KinesisFirehoseOutputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate
      .builder()
      .resourceARNUpdate(
        ResourceARN.unwrap(resourceARNUpdate): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate
      .wrap(buildAwsValue())
}
object KinesisFirehoseOutputUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate =
      zio.aws.kinesisanalyticsv2.model
        .KinesisFirehoseOutputUpdate(resourceARNUpdate)
    def resourceARNUpdate: ResourceARN
    def getResourceARNUpdate: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate.ReadOnly {
    override val resourceARNUpdate: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARNUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate
  ): zio.aws.kinesisanalyticsv2.model.KinesisFirehoseOutputUpdate.ReadOnly =
    new Wrapper(impl)
}
