package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.DatabaseARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GlueDataCatalogConfiguration(databaseARN: DatabaseARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfiguration = {
    import GlueDataCatalogConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfiguration
      .builder()
      .databaseARN(DatabaseARN.unwrap(databaseARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfiguration
      .wrap(buildAwsValue())
}
object GlueDataCatalogConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfiguration =
      zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfiguration(databaseARN)
    def databaseARN: DatabaseARN
    def getDatabaseARN: ZIO[Any, Nothing, DatabaseARN] =
      ZIO.succeed(databaseARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfiguration.ReadOnly {
    override val databaseARN: DatabaseARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .DatabaseARN(impl.databaseARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.GlueDataCatalogConfiguration
  ): zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfiguration.ReadOnly =
    new Wrapper(impl)
}
