package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateApplicationResponse(
    applicationDetail: zio.aws.kinesisanalyticsv2.model.ApplicationDetail
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationResponse = {
    import UpdateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationResponse
      .builder()
      .applicationDetail(applicationDetail.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.UpdateApplicationResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.UpdateApplicationResponse
      .wrap(buildAwsValue())
}
object UpdateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.UpdateApplicationResponse =
      zio.aws.kinesisanalyticsv2.model
        .UpdateApplicationResponse(applicationDetail.asEditable)
    def applicationDetail
        : zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly
    def getApplicationDetail: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly
    ] = ZIO.succeed(applicationDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationResponse
  ) extends zio.aws.kinesisanalyticsv2.model.UpdateApplicationResponse.ReadOnly {
    override val applicationDetail
        : zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.ApplicationDetail
        .wrap(impl.applicationDetail())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationResponse
  ): zio.aws.kinesisanalyticsv2.model.UpdateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
