package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{InAppTableName, Id}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReferenceDataSourceDescription(
    referenceId: Id,
    tableName: InAppTableName,
    s3ReferenceDataSourceDescription: zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription,
    referenceSchema: Optional[zio.aws.kinesisanalyticsv2.model.SourceSchema] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSourceDescription = {
    import ReferenceDataSourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSourceDescription
      .builder()
      .referenceId(Id.unwrap(referenceId): java.lang.String)
      .tableName(InAppTableName.unwrap(tableName): java.lang.String)
      .s3ReferenceDataSourceDescription(
        s3ReferenceDataSourceDescription.buildAwsValue()
      )
      .optionallyWith(referenceSchema.map(value => value.buildAwsValue()))(
        _.referenceSchema
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription
      .wrap(buildAwsValue())
}
object ReferenceDataSourceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSourceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription =
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription(
        referenceId,
        tableName,
        s3ReferenceDataSourceDescription.asEditable,
        referenceSchema.map(value => value.asEditable)
      )
    def referenceId: Id
    def tableName: InAppTableName
    def s3ReferenceDataSourceDescription
        : zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription.ReadOnly
    def referenceSchema
        : Optional[zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly]
    def getReferenceId: ZIO[Any, Nothing, Id] = ZIO.succeed(referenceId)
    def getTableName: ZIO[Any, Nothing, InAppTableName] = ZIO.succeed(tableName)
    def getS3ReferenceDataSourceDescription: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription.ReadOnly
    ] = ZIO.succeed(s3ReferenceDataSourceDescription)
    def getReferenceSchema: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly
    ] = AwsError.unwrapOptionField("referenceSchema", referenceSchema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSourceDescription
  ) extends zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription.ReadOnly {
    override val referenceId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives.Id(impl.referenceId())
    override val tableName: InAppTableName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .InAppTableName(impl.tableName())
    override val s3ReferenceDataSourceDescription
        : zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceDescription
        .wrap(impl.s3ReferenceDataSourceDescription())
    override val referenceSchema
        : Optional[zio.aws.kinesisanalyticsv2.model.SourceSchema.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.referenceSchema())
        .map(value => zio.aws.kinesisanalyticsv2.model.SourceSchema.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ReferenceDataSourceDescription
  ): zio.aws.kinesisanalyticsv2.model.ReferenceDataSourceDescription.ReadOnly =
    new Wrapper(impl)
}
