package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class LambdaOutput(resourceARN: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.LambdaOutput = {
    import LambdaOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.LambdaOutput
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.LambdaOutput.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.LambdaOutput.wrap(buildAwsValue())
}
object LambdaOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.LambdaOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.LambdaOutput =
      zio.aws.kinesisanalyticsv2.model.LambdaOutput(resourceARN)
    def resourceARN: ResourceARN
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.LambdaOutput
  ) extends zio.aws.kinesisanalyticsv2.model.LambdaOutput.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.LambdaOutput
  ): zio.aws.kinesisanalyticsv2.model.LambdaOutput.ReadOnly = new Wrapper(impl)
}
