package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.BooleanObject
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApplicationSnapshotConfigurationDescription(
    snapshotsEnabled: BooleanObject
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription = {
    import ApplicationSnapshotConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription
      .builder()
      .snapshotsEnabled(snapshotsEnabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription
      .wrap(buildAwsValue())
}
object ApplicationSnapshotConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model
        .ApplicationSnapshotConfigurationDescription(snapshotsEnabled)
    def snapshotsEnabled: BooleanObject
    def getSnapshotsEnabled: ZIO[Any, Nothing, BooleanObject] =
      ZIO.succeed(snapshotsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription.ReadOnly {
    override val snapshotsEnabled: BooleanObject =
      impl.snapshotsEnabled(): BooleanObject
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
