package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  RecordColumnSqlType,
  RecordColumnMapping,
  RecordColumnName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecordColumn(
    name: RecordColumnName,
    mapping: Optional[RecordColumnMapping] = Optional.Absent,
    sqlType: RecordColumnSqlType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordColumn = {
    import RecordColumn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordColumn
      .builder()
      .name(RecordColumnName.unwrap(name): java.lang.String)
      .optionallyWith(
        mapping.map(value =>
          RecordColumnMapping.unwrap(value): java.lang.String
        )
      )(_.mapping)
      .sqlType(RecordColumnSqlType.unwrap(sqlType): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.RecordColumn.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.RecordColumn.wrap(buildAwsValue())
}
object RecordColumn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordColumn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.RecordColumn =
      zio.aws.kinesisanalyticsv2.model
        .RecordColumn(name, mapping.map(value => value), sqlType)
    def name: RecordColumnName
    def mapping: Optional[RecordColumnMapping]
    def sqlType: RecordColumnSqlType
    def getName: ZIO[Any, Nothing, RecordColumnName] = ZIO.succeed(name)
    def getMapping: ZIO[Any, AwsError, RecordColumnMapping] =
      AwsError.unwrapOptionField("mapping", mapping)
    def getSqlType: ZIO[Any, Nothing, RecordColumnSqlType] =
      ZIO.succeed(sqlType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordColumn
  ) extends zio.aws.kinesisanalyticsv2.model.RecordColumn.ReadOnly {
    override val name: RecordColumnName =
      zio.aws.kinesisanalyticsv2.model.primitives.RecordColumnName(impl.name())
    override val mapping: Optional[RecordColumnMapping] = zio.aws.core.internal
      .optionalFromNullable(impl.mapping())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.RecordColumnMapping(value)
      )
    override val sqlType: RecordColumnSqlType =
      zio.aws.kinesisanalyticsv2.model.primitives
        .RecordColumnSqlType(impl.sqlType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordColumn
  ): zio.aws.kinesisanalyticsv2.model.RecordColumn.ReadOnly = new Wrapper(impl)
}
