package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{Timestamp, ApplicationName}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DeleteApplicationRequest(
    applicationName: ApplicationName,
    createTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest = {
    import DeleteApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .createTimestamp(Timestamp.unwrap(createTimestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DeleteApplicationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.DeleteApplicationRequest =
      zio.aws.kinesisanalyticsv2.model
        .DeleteApplicationRequest(applicationName, createTimestamp)
    def applicationName: ApplicationName
    def createTimestamp: Timestamp
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCreateTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(createTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.DeleteApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val createTimestamp: Timestamp =
      zio.aws.kinesisanalyticsv2.model.primitives
        .Timestamp(impl.createTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationRequest
  ): zio.aws.kinesisanalyticsv2.model.DeleteApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
