package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplicationConfiguration(
    sqlApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfiguration
    ] = Optional.Absent,
    flinkApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfiguration
    ] = Optional.Absent,
    environmentProperties: Optional[
      zio.aws.kinesisanalyticsv2.model.EnvironmentProperties
    ] = Optional.Absent,
    applicationCodeConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfiguration
    ] = Optional.Absent,
    applicationSnapshotConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration
    ] = Optional.Absent,
    vpcConfigurations: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.VpcConfiguration]
    ] = Optional.Absent,
    zeppelinApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfiguration = {
    import ApplicationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfiguration
      .builder()
      .optionallyWith(
        sqlApplicationConfiguration.map(value => value.buildAwsValue())
      )(_.sqlApplicationConfiguration)
      .optionallyWith(
        flinkApplicationConfiguration.map(value => value.buildAwsValue())
      )(_.flinkApplicationConfiguration)
      .optionallyWith(
        environmentProperties.map(value => value.buildAwsValue())
      )(_.environmentProperties)
      .optionallyWith(
        applicationCodeConfiguration.map(value => value.buildAwsValue())
      )(_.applicationCodeConfiguration)
      .optionallyWith(
        applicationSnapshotConfiguration.map(value => value.buildAwsValue())
      )(_.applicationSnapshotConfiguration)
      .optionallyWith(
        vpcConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcConfigurations)
      .optionallyWith(
        zeppelinApplicationConfiguration.map(value => value.buildAwsValue())
      )(_.zeppelinApplicationConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationConfiguration
      .wrap(buildAwsValue())
}
object ApplicationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.ApplicationConfiguration =
      zio.aws.kinesisanalyticsv2.model.ApplicationConfiguration(
        sqlApplicationConfiguration.map(value => value.asEditable),
        flinkApplicationConfiguration.map(value => value.asEditable),
        environmentProperties.map(value => value.asEditable),
        applicationCodeConfiguration.map(value => value.asEditable),
        applicationSnapshotConfiguration.map(value => value.asEditable),
        vpcConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        zeppelinApplicationConfiguration.map(value => value.asEditable)
      )
    def sqlApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfiguration.ReadOnly
    ]
    def flinkApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfiguration.ReadOnly
    ]
    def environmentProperties: Optional[
      zio.aws.kinesisanalyticsv2.model.EnvironmentProperties.ReadOnly
    ]
    def applicationCodeConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfiguration.ReadOnly
    ]
    def applicationSnapshotConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration.ReadOnly
    ]
    def vpcConfigurations: Optional[
      List[zio.aws.kinesisanalyticsv2.model.VpcConfiguration.ReadOnly]
    ]
    def zeppelinApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration.ReadOnly
    ]
    def getSqlApplicationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sqlApplicationConfiguration",
      sqlApplicationConfiguration
    )
    def getFlinkApplicationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "flinkApplicationConfiguration",
      flinkApplicationConfiguration
    )
    def getEnvironmentProperties: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.EnvironmentProperties.ReadOnly
    ] =
      AwsError.unwrapOptionField("environmentProperties", environmentProperties)
    def getApplicationCodeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationCodeConfiguration",
      applicationCodeConfiguration
    )
    def getApplicationSnapshotConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationSnapshotConfiguration",
      applicationSnapshotConfiguration
    )
    def getVpcConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.VpcConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcConfigurations", vpcConfigurations)
    def getZeppelinApplicationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "zeppelinApplicationConfiguration",
      zeppelinApplicationConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationConfiguration.ReadOnly {
    override val sqlApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sqlApplicationConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.SqlApplicationConfiguration.wrap(value)
      )
    override val flinkApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.flinkApplicationConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfiguration
          .wrap(value)
      )
    override val environmentProperties: Optional[
      zio.aws.kinesisanalyticsv2.model.EnvironmentProperties.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentProperties())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.EnvironmentProperties.wrap(value)
      )
    override val applicationCodeConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationCodeConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfiguration
          .wrap(value)
      )
    override val applicationSnapshotConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationSnapshotConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfiguration
          .wrap(value)
      )
    override val vpcConfigurations: Optional[
      List[zio.aws.kinesisanalyticsv2.model.VpcConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.VpcConfiguration.wrap(item)
        }.toList
      )
    override val zeppelinApplicationConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.zeppelinApplicationConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfiguration
  ): zio.aws.kinesisanalyticsv2.model.ApplicationConfiguration.ReadOnly =
    new Wrapper(impl)
}
