package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ObjectVersion,
  FileKey,
  BucketARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3ContentLocationUpdate(
    bucketARNUpdate: Optional[BucketARN] = Optional.Absent,
    fileKeyUpdate: Optional[FileKey] = Optional.Absent,
    objectVersionUpdate: Optional[ObjectVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocationUpdate = {
    import S3ContentLocationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocationUpdate
      .builder()
      .optionallyWith(
        bucketARNUpdate.map(value => BucketARN.unwrap(value): java.lang.String)
      )(_.bucketARNUpdate)
      .optionallyWith(
        fileKeyUpdate.map(value => FileKey.unwrap(value): java.lang.String)
      )(_.fileKeyUpdate)
      .optionallyWith(
        objectVersionUpdate.map(value =>
          ObjectVersion.unwrap(value): java.lang.String
        )
      )(_.objectVersionUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.S3ContentLocationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.S3ContentLocationUpdate
      .wrap(buildAwsValue())
}
object S3ContentLocationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.S3ContentLocationUpdate =
      zio.aws.kinesisanalyticsv2.model.S3ContentLocationUpdate(
        bucketARNUpdate.map(value => value),
        fileKeyUpdate.map(value => value),
        objectVersionUpdate.map(value => value)
      )
    def bucketARNUpdate: Optional[BucketARN]
    def fileKeyUpdate: Optional[FileKey]
    def objectVersionUpdate: Optional[ObjectVersion]
    def getBucketARNUpdate: ZIO[Any, AwsError, BucketARN] =
      AwsError.unwrapOptionField("bucketARNUpdate", bucketARNUpdate)
    def getFileKeyUpdate: ZIO[Any, AwsError, FileKey] =
      AwsError.unwrapOptionField("fileKeyUpdate", fileKeyUpdate)
    def getObjectVersionUpdate: ZIO[Any, AwsError, ObjectVersion] =
      AwsError.unwrapOptionField("objectVersionUpdate", objectVersionUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.S3ContentLocationUpdate.ReadOnly {
    override val bucketARNUpdate: Optional[BucketARN] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketARNUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.BucketARN(value)
      )
    override val fileKeyUpdate: Optional[FileKey] = zio.aws.core.internal
      .optionalFromNullable(impl.fileKeyUpdate())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.FileKey(value))
    override val objectVersionUpdate: Optional[ObjectVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectVersionUpdate())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.ObjectVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocationUpdate
  ): zio.aws.kinesisanalyticsv2.model.S3ContentLocationUpdate.ReadOnly =
    new Wrapper(impl)
}
