package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ObjectVersion,
  FileKey,
  BucketARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3ContentLocation(
    bucketARN: BucketARN,
    fileKey: FileKey,
    objectVersion: Optional[ObjectVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocation = {
    import S3ContentLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocation
      .builder()
      .bucketARN(BucketARN.unwrap(bucketARN): java.lang.String)
      .fileKey(FileKey.unwrap(fileKey): java.lang.String)
      .optionallyWith(
        objectVersion.map(value =>
          ObjectVersion.unwrap(value): java.lang.String
        )
      )(_.objectVersion)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.S3ContentLocation.wrap(buildAwsValue())
}
object S3ContentLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.S3ContentLocation =
      zio.aws.kinesisanalyticsv2.model.S3ContentLocation(
        bucketARN,
        fileKey,
        objectVersion.map(value => value)
      )
    def bucketARN: BucketARN
    def fileKey: FileKey
    def objectVersion: Optional[ObjectVersion]
    def getBucketARN: ZIO[Any, Nothing, BucketARN] = ZIO.succeed(bucketARN)
    def getFileKey: ZIO[Any, Nothing, FileKey] = ZIO.succeed(fileKey)
    def getObjectVersion: ZIO[Any, AwsError, ObjectVersion] =
      AwsError.unwrapOptionField("objectVersion", objectVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocation
  ) extends zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly {
    override val bucketARN: BucketARN =
      zio.aws.kinesisanalyticsv2.model.primitives.BucketARN(impl.bucketARN())
    override val fileKey: FileKey =
      zio.aws.kinesisanalyticsv2.model.primitives.FileKey(impl.fileKey())
    override val objectVersion: Optional[ObjectVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.objectVersion())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ObjectVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentLocation
  ): zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly = new Wrapper(
    impl
  )
}
