package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{BasePath, BucketARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3ContentBaseLocation(
    bucketARN: BucketARN,
    basePath: Optional[BasePath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentBaseLocation = {
    import S3ContentBaseLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentBaseLocation
      .builder()
      .bucketARN(BucketARN.unwrap(bucketARN): java.lang.String)
      .optionallyWith(
        basePath.map(value => BasePath.unwrap(value): java.lang.String)
      )(_.basePath)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocation.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocation.wrap(buildAwsValue())
}
object S3ContentBaseLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentBaseLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocation =
      zio.aws.kinesisanalyticsv2.model
        .S3ContentBaseLocation(bucketARN, basePath.map(value => value))
    def bucketARN: BucketARN
    def basePath: Optional[BasePath]
    def getBucketARN: ZIO[Any, Nothing, BucketARN] = ZIO.succeed(bucketARN)
    def getBasePath: ZIO[Any, AwsError, BasePath] =
      AwsError.unwrapOptionField("basePath", basePath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentBaseLocation
  ) extends zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocation.ReadOnly {
    override val bucketARN: BucketARN =
      zio.aws.kinesisanalyticsv2.model.primitives.BucketARN(impl.bucketARN())
    override val basePath: Optional[BasePath] = zio.aws.core.internal
      .optionalFromNullable(impl.basePath())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.BasePath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ContentBaseLocation
  ): zio.aws.kinesisanalyticsv2.model.S3ContentBaseLocation.ReadOnly =
    new Wrapper(impl)
}
